/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.login;

import com.cleveranalytics.common.client.CanRestClient;
import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.authn.client.AccountsClient;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.factory.ShellAuthnClientFactory;
import com.cleveranalytics.shell.client.factory.ShellClientType;
import com.cleveranalytics.shell.config.ShellConfig;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class LoginCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(LoginCommand.class);
    @Value(value="${service.name}")
    private final String serviceName;
    @Value(value="${can.service.authn.serverUrl:#{null}}")
    private final String authnServerUrl;
    private String authnServer;
    private final ShellContext context;
    private final String envVariableAccessToken = System.getenv("CM_ACCESS_TOKEN");
    private final String envVariableAccessKeyId = System.getenv("AWS_ACCESS_KEY_ID");
    private final String envVariableSecretAccessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
    private static final String DEFAULT_SERVER = "https://secure.clevermaps.io";
    private static final String SETUP_TIP = "Tip: Use the 'setup' command to setup your Shell credentials and configuration\n";

    @Autowired
    public LoginCommand(ShellContext context) {
        this.serviceName = null;
        this.authnServerUrl = null;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"login"}, help="Log in as a user to CleverMaps with correct credentials.")
    public void loginCmd(@CliOption(key={"server"}, mandatory=false, help="Server to connect to. Defaults to \"https://secure.clevermaps.io.\"") String server, @CliOption(key={"proxyHost"}, mandatory=false, help="Hostname of the proxy server.") String proxyHost, @CliOption(key={"proxyPort"}, mandatory=false, help="Proxy server port number.") Integer proxyPort, @CliOption(key={"dumpDirectory"}, mandatory=false, help="Directory where your dumps will be stored.") String dumpDirectory, @CliOption(key={"bearerToken"}, mandatory=false, help="JWT token generated after signing with limited 1h validity.") String bearerToken, @CliOption(key={"accessToken"}, mandatory=false, help="Generated CleverMaps access token.") String accessToken, @CliOption(key={"s3AccessKeyId"}, mandatory=false, help="AWS S3 Access Key ID.", specifiedDefaultValue="") String s3AccessKeyId, @CliOption(key={"s3SecretAccessKey"}, mandatory=false, help="AWS S3 Secret Access Key.", specifiedDefaultValue="") String s3SecretAccessKey) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (this.context.isIncompatibleVersion()) {
                throw new CleverMapsShellException("It's forbidden to login if a change with 'FATAL' level has been introduced. Please download the latest version.");
            }
            ShellConfig config = new ShellConfig();
            File configFile = DumpUtils.fetchConfigFile();
            if (configFile != null) {
                logger.error("Found config file: " + configFile.getAbsolutePath());
                DumpUtils.loadProperties((ShellConfig)config, (File)configFile);
            }
            this.context.clear();
            boolean set = this.setContextProperties(config, accessToken, server, proxyHost, proxyPort, dumpDirectory, bearerToken, s3AccessKeyId, s3SecretAccessKey);
            if (!set) {
                return;
            }
            if (this.authnServerUrl != null) {
                this.authnServer = this.authnServerUrl;
                logger.error("\nObtaining refresh token from " + this.authnServerUrl);
            } else {
                this.authnServer = this.context.getConnectedServer();
            }
            this.context.setAuthnServer(this.authnServer);
            this.context.setServiceName(this.serviceName);
            CanRestClient canRestClient = this.initCanRestClient(accessToken, bearerToken);
            this.context.setCanRestClient(canRestClient);
            this.context.setCurrentProject(null);
            this.context.setOpenDump(false);
        }
        catch (Exception ex) {
            try {
                ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
            }
            finally {
                this.context.clear();
            }
        }
    }

    private boolean setContextProperties(ShellConfig config, String accessToken, String server, String proxyHost, Integer proxyPort, String dumpDirectory, String bearerToken, String accessKeyId, String secretAccessKey) {
        boolean accessTokenSet = true;
        if (accessToken != null) {
            this.context.setAccessToken(accessToken);
        } else if (this.envVariableAccessToken != null) {
            this.context.setAccessToken(this.envVariableAccessToken);
        } else if (config.getAccessToken() != null) {
            this.context.setAccessToken(config.getAccessToken());
        } else {
            accessTokenSet = false;
        }
        if (bearerToken == null) {
            if (!accessTokenSet) {
                logger.error("\nPlease specify access token (--accessToken) for this command\n");
                logger.error(SETUP_TIP);
                return false;
            }
        } else {
            this.context.setBearerToken(bearerToken);
        }
        boolean showConfigTip = false;
        if (server != null) {
            this.context.setConnectedServer(server);
        } else if (config.getServer() != null) {
            logger.error("\t* setting " + config.getServer() + " as default server");
            this.context.setConnectedServer(config.getServer());
        } else {
            logger.error("\t* setting https://secure.clevermaps.io as default server");
            this.context.setConnectedServer(DEFAULT_SERVER);
            showConfigTip = true;
        }
        if (dumpDirectory != null) {
            this.context.setDumpDirectory(dumpDirectory);
        } else if (config.getDumpDirectory() != null) {
            logger.error("\t* setting " + config.getDumpDirectory() + " as default dump directory");
            this.context.setDumpDirectory(config.getDumpDirectory());
        } else {
            logger.error("\t* setting " + System.getProperty("user.dir") + " as default dump directory");
            this.context.setDumpDirectory(System.getProperty("user.dir"));
            showConfigTip = true;
        }
        if (proxyHost != null) {
            this.context.setProxyHost(proxyHost);
        } else if (config.getProxyHost() != null) {
            logger.error("\t* setting " + config.getProxyHost() + " as default proxy server hostname");
            this.context.setProxyHost(config.getProxyHost());
        }
        if (proxyPort != null) {
            this.context.setProxyPort(proxyPort);
        } else if (config.getProxyPort() != null) {
            logger.error("\t* setting " + config.getProxyPort() + " as default proxy server port number");
            this.context.setProxyPort(config.getProxyPort());
        }
        if (accessKeyId != null) {
            this.context.setAccessKeyId(accessKeyId);
        } else if (this.envVariableAccessKeyId != null) {
            this.context.setAccessKeyId(this.envVariableAccessKeyId);
        } else if (config.getS3AccessKeyId() != null) {
            this.context.setAccessKeyId(config.getS3AccessKeyId());
        }
        if (secretAccessKey != null) {
            this.context.setSecretAccessKey(secretAccessKey);
        } else if (this.envVariableSecretAccessKey != null) {
            this.context.setSecretAccessKey(this.envVariableSecretAccessKey);
        } else if (config.getS3SecretAccessKey() != null) {
            this.context.setSecretAccessKey(config.getS3SecretAccessKey());
        }
        if (showConfigTip) {
            logger.error("\nTip: Use the 'setup' command to setup your Shell credentials and configuration\n");
        }
        return true;
    }

    private CanRestClient initCanRestClient(String accessToken, String bearerToken) {
        CanRestClient canRestClient;
        ShellAuthnClientFactory clientFactory = new ShellAuthnClientFactory(this.context);
        if (accessToken != null) {
            canRestClient = clientFactory.getClient(ShellClientType.ACCESS_TOKEN);
            this.context.setUserEmail(new AccountsClient(canRestClient).currentAccount().getEmail());
            logger.error("\nSuccessfully logged in as " + this.context.getUserEmail() + " (using access token)\n");
        } else if (bearerToken != null) {
            canRestClient = clientFactory.getClient(ShellClientType.BEARER_TOKEN);
            this.context.setUserEmail(new AccountsClient(canRestClient).currentAccount(this.context.getBearerToken()).getEmail());
            logger.error("\nSuccessfully logged in as " + this.context.getUserEmail() + " (using bearer token)\n");
        } else if (this.context.getAccessToken() != null) {
            canRestClient = clientFactory.getClient(ShellClientType.ACCESS_TOKEN);
            this.context.setUserEmail(new AccountsClient(canRestClient).currentAccount().getEmail());
            logger.error("\nSuccessfully logged in as " + this.context.getUserEmail() + " (using access token)\n");
        } else {
            canRestClient = clientFactory.getClient(ShellClientType.BEARER_TOKEN);
            this.context.setUserEmail(new AccountsClient(canRestClient).currentAccount(this.context.getBearerToken()).getEmail());
            logger.error("\nSuccessfully logged in as " + this.context.getUserEmail() + " (using bearer token)\n");
        }
        return canRestClient;
    }
}

